﻿using System;
using PostitCore;
using PostitCommon;
using System.Collections.Generic;
using Newtonsoft.Json;
using System.Net.Http;

namespace DeXGets
{
    public class ContactContactDetails : BaseClass
    {
        /// <summary>
        /// Usage 
        /// Dictionary<Guid, ContactContactBasics.ContactBasics_Response> _ContactBasics;
        /// // Get the list of Contacts Details - who links to whom,emails, ...
        /// ContactContactDetails cContactDetails = new ContactContactDetails();
        /// _ContactDetails = cContactDetails.GetValues(token, key, pHttpClient);
           
        /// </summary>
        public class ContactDetails_Response
        {
            public Guid ExternalID;
            public string Salutation;
            public List<AddressRecords> Addresses;
            public List<LearnerRelationships> LearnerRelationships;
            public List<Email> Emails;
            public List<Telephone> Telephones;

        }
        // Supporting classes
        public class Telephone
        {
            public Guid ExternalID;
            public string TelephoneNumber;
            public BaseLookups LocationType;
            public Nullable<bool> IsFirstPointOfContact;
            public Nullable<bool> UseForAutomatedMessages;
        }
        public class Email
        {
            public Guid ExternalID;
            public string EmailAddress;
            public BaseLookups LocationType;
            public Nullable<bool> IsMainEmail;
            public Nullable<bool> UseForAutomatedMessages;
        }
        public class AddressRecords
        {
            public Guid ExternalID;
            public Nullable<DateTime> StartDate;
            public Nullable<DateTime> EndDate;
            public Address Address;
        }
        public class Address
        {
            public Guid ExternalID;
            public string Apartment;
            public string BuildingNumber;
            public string BuildingName;
            public string Street;
            public string District;
            public string Town;
            public string AdministrativeArea;
            public string Postcode;
            public string AddressIdentifier;
        }
        public class LearnerRelationships
        {
            public Guid ExternalID;
            public Nullable<bool> HasCourtOrder;
            public Nullable<bool> HasParentalResponsibility;
            public string Priority; // Possibly should be an int but it makes no difference in this case
            public BaseLookups Learner;
        }

        /// <summary>
        /// Returns the set of contact contact details
        /// </summary>
        /// <param name="token"></param>
        /// <param name="key"></param>
        /// <param name="httpClient"></param>
        /// <returns></returns>
        public Dictionary<Guid, ContactDetails_Response> GetValues(string token, string key, HttpClient httpClient)
        {
            Dictionary<Guid, ContactDetails_Response> values = new Dictionary<Guid, ContactDetails_Response>();
            string URL_ContactDetails = SetURL("Learner", "ContactContactDetails?$expand=Emails,LearnerRelationships,Addresses,Telephones");
            string resp = DoCall(URL_ContactDetails, token, httpClient, key);
            ODataResponse<ContactDetails_Response> contacts = null;
            try
            {
                contacts = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<ContactDetails_Response>>(resp);
                foreach (ContactDetails_Response s in contacts.Value)
                {
                    values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(contacts.NextLink))
                {
                    resp = DoCall(GetNextLink(contacts.NextLink), token, httpClient, key);
                    contacts = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<ContactDetails_Response>>(resp);
                    foreach (ContactDetails_Response s in contacts.Value)
                    {
                        values.Add(s.ExternalID, s);
                    }
                }
            }
            catch
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}
